﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using STNCInterpreter;
using STNCFormers;

namespace sample_dc
{
    class TParameter
    {
        public double Value;
        public bool Empty;

        public void SetValue(in bool AEmpty, in double AValue)
        {
            Value = AValue;
            Empty = AEmpty;
        }

        public void Clear()
        {
            SetValue(true, 0);
        }
    }
    
    class TDrillingCycles
    {
        private INCT_CLData CLD;
        private TNCDCAxisIndexes AxisIdxs;
        private int CurParameter;
        private int Num;
        private TNC3DPoint InitPoint;
        private TParameter RTP;
        private TParameter RFP;
        private TParameter SDIS;
        private TParameter DP;
        private TParameter DPR;

        public TDrillingCycles()
        {
            RTP = new TParameter();
            RFP = new TParameter();
            SDIS = new TParameter();
            DP = new TParameter();
            DPR = new TParameter();
        }

        // Initialization
        public void Init(INCT_CLData ACLD, TNCDCAxisIndexes AAxisIndxs)
        {
            CLD = ACLD;
            AxisIdxs = AAxisIndxs;
        }

        // Set cycle number
        public void SetCycleNum(int ACycleNum)
        {
            if (ACycleNum  == 81)
            {
                Cancel();
                Num = ACycleNum;
                CurParameter = 1;
            }

        }

        // Set next parameter
        public void SetNextParameter(bool Empty, double Value)
        {
            switch (CurParameter)
            {
                case 1: 
                    RTP.SetValue(Empty, Value);
                    break;
                case 2: 
                    RFP.SetValue(Empty, Value);
                    break;
                case 3: 
                    SDIS.SetValue(Empty, Value);
                    break;
                case 4: 
                    DP.SetValue(Empty, Value);
                    break;
                case 5: 
                    DPR.SetValue(Empty, Value);
                    break;
            }            
            CurParameter = CurParameter + 1;
        }
        
        // Clear data
        public void Cancel()
        {
            Num = -1;
            CurParameter = 0;
            RTP.Clear();
            RFP.Clear(); 
            SDIS.Clear();  
            DP.Clear();     
            DPR.Clear();
        }

        // Get base level
        public double GetBaseLevel()
        {
            if (RTP.Empty)
            {
                return 0;
            }
            else
            {
                return RTP.Value;
            }
        }

        // Formation toolpath
        public void DoCycle()
        {
            // Creating former
            INCT_DrillingCycleFormer Former = CLD.CreateDrillingCycleFormer(TNCDrillingCycleType.dctSimple);

            // Filling parameters
            Former.AxisIndexes = AxisIdxs;
            Former.Plane = TNCPlaneType.ptXY;
            Former.HoleCenter = InitPoint;
            Former.HoleCenterMode = true;
            Former.RapidLevel = RFP.Value + SDIS.Value;
            if (DP.Empty)
            {
                Former.BottomLevel = RFP.Value - DPR.Value;
            }
            else
            {
                Former.BottomLevel = DP.Value;
            }
            Former.TopLevel = RTP.Value;
            Former.Feedrate = 100;
            Former.MPM = true;
            Former.Count = 1;

            // Make toolpath
            Former.MakeWorkpath();
        }

        // Set init level (= current tool position)
        public void SetInitLevel()
        {
            InitPoint.X = CLD.GetAxisValue(AxisIdxs.X);
            InitPoint.Y = CLD.GetAxisValue(AxisIdxs.Y);
            InitPoint.Z = CLD.GetAxisValue(AxisIdxs.Z);
        }
    }
}
